/*jslint node: true, nomen: true, unparam: true */
/*global jquery, _, $, define, navigator, window */

define([ 'Portal', 'backbone', 'marionette', 'OrdersViewer', 'NoteWriter', 'parser',
    'modules/staff-user-disclaimer/sudView',
    'modules/staff-user-disclaimer/AppletHeaderView',
    'modules/jqm-modal-dialog/ModalDialogView',
    'modules/navigation/PanelNavigationView',
    'modules/user-navigation/userNavigationView',
    'modules/alerts-list/alertsListView',
    'modules/alerts-list/Notifications',
    'modules/infobar/InfoBarView',
    'modules/infoBarSub/InfoBarSubView',
    'modules/infoBarFooter/InfoBarFooterView',
    'modules/app-name/AppNameView',
    'modules/applet-title/appletTitleView',
    'modules/user-context/HelloUserContextView',
    'modules/user-context/UserContextView',
    'modules/patient-context/PatientContextView',
    'modules/subject-info/subjectInfoView',
    'modules/navigation/NavItems',
    'modules/navigation/NavItem',
    'core/models/Model',
    'hbs!_assets/templates/appletCSS'],
    function (Portal, Backbone, Marionette, ordersViewer, noteWriter, parser, sudView, AppletHeaderView, ModalDialogView, PanelNavigationView, UserNavigationView, AlertsListView, Notifications, InfoBarView, InfoBarSubView, InfoBarFooterView, AppNameView, AppletTitleView, HelloUserContextView, UserContextView, PatientContextView, SubjectInfoView, NavItems, NavItem, Model, appletCSSTemplate) {
        'use strict';
        return Backbone.Marionette.Controller.extend({
            defaultAction: function() {
                if ( typeof Portal.infobarSubRegion.currentView.titleRegion.currentView !== 'undefined' ) {
                    Portal.infobarSubRegion.currentView.titleRegion.show( new AppletTitleView({
                        model: new Backbone.Model()
                    }) );
                    Portal.vent.trigger('openPanel');
                    Portal.containerRegion.close();
                }
            },
            initialize: function (options) {
                var that = this,
                    infoBarSubLayout = new InfoBarSubView(),
                    infoBarFooterLayout = new InfoBarFooterView(),
                    updateWidgetsOnLoadPatient = function() {};

                Portal.addRegions({ subheadingRegion: infoBarSubLayout.subtitleRegion.el });

                this.navItems = new NavItems();
                this.subjectNavItems =  new NavItems();
                this.userNavItems =  new NavItems();
                this.infoBarModel = new Model({ uber: Portal.uber });
                this.infoBarLayout = new InfoBarView({ model: this.infoBarModel });

                Portal.infobarRegion.show(this.infoBarLayout);
                this.infoBarLayout.patientRegion.show(new PatientContextView());
                
                Portal.infobarSubRegion.show(infoBarSubLayout);
                
                Portal.infobarFooterRegion.show(infoBarFooterLayout);
                infoBarFooterLayout.userRegion.show(new UserContextView());
                infoBarFooterLayout.appNameRegion.show(new AppNameView());

                Portal.subheadingRegion.on("show", function(view) {
                    $(this.el).parent().toggleClass('subtitled', $(this.el + ":empty").length === 1 );
                });

                new SubjectInfoView();

                //Somewhere better
                $(window).on('resize', function(){
                     Portal.vent.trigger('close:popups');
                });

                // load applet CSS
                Portal.vent.on('load:css', function (cssURL) {
                    var $head = $(Portal.head.el), $existingAppletCSS = $head.find('link[for="applet"]'), newAppletCSS = '';

                    if (cssURL) {
                        if ($existingAppletCSS.length === 0) {
                            newAppletCSS = appletCSSTemplate({
                                url : cssURL
                            });
                            $head.append(newAppletCSS);
                        } else {
                            $existingAppletCSS.attr('href', cssURL);
                        }
                    } else {
                        $existingAppletCSS.remove();
                    }
                });

                // add applets to menu 
                // if it's not uber portal, dynamically add menu items
                Portal.vent.on('add:applet', function (options) {
                    that.addMenuItem(options.toJSON());
                });
                Portal.commands.setHandler('show-applet-search', function (options) {
                    that.infoBarLayout.searchIconRegion.show(new Portal.ListGenerator.SearchIconView({
                        className: 'ui-btn-left'
                    } ));
                });

                Portal.vent.on('add:link', function (options) {
                    that.addMenuItem(options);
                });

                Portal.vent.on('load:applet', function(BootStrapModel) {
                    infoBarSubLayout.titleRegion.show(new AppletTitleView({
                        model: BootStrapModel
                    }));
                    // toggling class "subtitled" not needed as the AppletTitleView creates a new heading without the class
                });

                // initialize widgets on load patient
                Portal.vent.once('load:patient', function() {
                    var $ordersViewerBtn,
                        $progressNotesBtn,
                        userSessionJSON = parser.flattenLinks(Portal.userSession()).toJSON(), // flattenLinks changes the model, only needs to be done once
                        patientJSON = Portal.patient().toJSON(),
                        ordersBySiteURI = Portal.patient().get('patient-orders').href,
                        clinicalEventResourceDirectoryURI = Portal.staff().get('clinical-event-resource-directory').get('href') + "?assigningAuthority=" + Portal.patient().get('patientIdentifier').assigningAuthority + "&patientId=" + Portal.patient().get('patientIdentifier').uniqueId;

                    if (Portal.widgets.indexOf('orders-viewer') >= 0) {
                        $ordersViewerBtn = $('#orders-viewer-btn').removeClass("ui-btn-hidden");
                        if ($ordersViewerBtn.length !== 0) {
                            $ordersViewerBtn.orderManagement();
                            $ordersViewerBtn.orderManagement('update', {user: userSessionJSON, patient: patientJSON, resourceURI: ordersBySiteURI});
                        }
                    }
                    if (Portal.widgets.indexOf('note-writer') >= 0) {
                        $progressNotesBtn = $('#progress-notes-btn').removeClass("ui-btn-hidden");
                        if ($progressNotesBtn.length !== 0) {
                            $progressNotesBtn.progressNotes({
                                beforeOpen: function(e) {
                                    Portal.vent.trigger( "note-writer-open", e, {noteWriter: this} );
                                },
                                onSave: function(e) {
                                    Portal.vent.trigger( "note-writer-save", e, {noteWriter: this} );
                                },
                                onSign: function(e) {
                                    Portal.vent.trigger( "note-writer-sign", e, {noteWriter: this} );
                                }
                            });

							// adding progressNotes as a property of Portal
							Portal.progressNotes = function(){
								return $progressNotesBtn.progressNotes.apply( $progressNotesBtn , Array.prototype.slice.call(arguments) );// Array.prototype.slice.call(arguments) // ["open"]
							};
							// anyone wanting to add/append note to note writter can use the following line
							// Portal.vent.trigger("addNote", {} , {noteBody:"note from applet ctrlr"});
							this.listenTo(Portal.vent , "add-note" , function(e ,d){
								$progressNotesBtn.progressNotes("addNote", {body: d.noteBody, healthFactors: d.healthFactors });
							});

                            $progressNotesBtn.progressNotes('update', {user: userSessionJSON, patient: patientJSON, resourceURI: clinicalEventResourceDirectoryURI});
                        }
                    }

                   updateWidgetsOnLoadPatient();
                });

                updateWidgetsOnLoadPatient = function() {
                    Portal.vent.on('load:patient', function() {
                        var patientJSON = Portal.patient().toJSON(),
                            ordersBySiteURI = Portal.patient().get('patient-orders').href,
                            clinicalEventResourceDirectoryURI = Portal.staff().get('clinical-event-resource-directory').get('href') + "?assigningAuthority=" + Portal.patient().get('patientIdentifier').assigningAuthority + "&patientId=" + Portal.patient().get('patientIdentifier').uniqueId;
                        
                        if (Portal.widgets.indexOf('orders-viewer') >= 0) {
                            $('#orders-viewer-btn:not(.ui-btn-hidden)').orderManagement('update', {patient: patientJSON, resourceURI: ordersBySiteURI});
                        }
                        if (Portal.widgets.indexOf('note-writer') >= 0) {
                            $('#progress-notes-btn:not(.ui-btn-hidden)').progressNotes('update', {patient: patientJSON, resourceURI: clinicalEventResourceDirectoryURI});
                        }
                    });
                };

                Portal.vent.on('load:staff', function (options) {
                    var panelNavigationView,
                        userNavigationView,
                        alertsListView;

                    //Check for Signed SUD
                    new Backbone.Model().fetch({
                        url: Portal.staff().get('staff-user-disclaimer').get('href'),
                        success: function(response) {
                            if (!response.get('staffUserDisclaimerAccepted')) {
                                Portal.execute( 'staff-user-disclaimer');
                            }
                        }
                    });

                    if (!Portal.uber) {
                        panelNavigationView = new PanelNavigationView({
                            collection: that.subjectNavItems
                        });
                        userNavigationView = new UserNavigationView({
                            collection: that.userNavItems
                        });
                    } else {
                        // uber portal
                        that.infoBarModel.set({ uber: true });
                        that.infoBarLayout.patientRegion.show(new PatientContextView());
//                        that.infoBarLayout.subjectIconRegion.show(new SubjectIconView());  CHECK IF THIS NOT NEEDED
                        that.infoBarLayout.userRegion.show(new HelloUserContextView());

                        panelNavigationView = new PanelNavigationView({
                            collection: that.navItems
                        });
                        Portal.userSession().flattenLinks();
                        that.navItems.fetch({
                            url: Portal.userSession().get('portal-favorites').href
                        });

                        userNavigationView = new UserNavigationView({
                            collection: that.userNavItems
                        });

                        var notifications = new Notifications();
                        alertsListView = new AlertsListView({
                            collection: notifications
                        });
                        Portal.alertsListRegion.show(alertsListView);

                        var updateNotifications = function () {
                            notifications.fetch({
                                url: Portal.resources().get('broadcast-messages').get('href')
                            }).done(function (response) {
                                var $alertButton = $(that.infoBarLayout.$el.find('#alerts-list')),
                                    $alertBadgeRegion = $(that.infoBarLayout.alertBadgeRegion.el),
                                    key = 'last-alert-date',
                                    storedDate,
                                    number,
                                    count = 0;

                                storedDate = localStorage.getItem(key);

                                if (storedDate) {
                                    // badge is response length of things with later dates
                                    $.each(response, function () {
                                        if (this.date > storedDate) {
                                            count = count + 1;
                                        } else {
                                            return false;
                                        }
                                    });
                                    number = count;
                                } else {
                                    // badge is response list length
                                    number = response.length;
                                }

                                $alertBadgeRegion.html(number)[number > 0 ? 'show' : 'hide']();
                                $alertButton[response.length > 0 ? 'show' : 'hide']();
                            });
                        };

                        updateNotifications();
                        setTimeout(function () {
                            updateNotifications();
                        }, 30000);
                    }
                    Portal.userMenuRegion.show(userNavigationView);
                    Portal.panelRegion.show(panelNavigationView);
                });
                    
                Portal.commands.setHandler('staff-user-disclaimer', function (options) {
                    that.drawSud();
                });

                Portal.reqres.setHandler('get-applet-options', function (appletId) {
                    return that.getAppletOptions(appletId);
                });

                Portal.commands.setHandler('set-patient-context', function (options) {
                    that.setPatientContext(options);
                });

            },
            addMenuItem: function(options){
                var navItem = new NavItem(options);

                if (navItem.isValid()) {
                    switch(navItem.get('focus')) {
                        case "subject":
                            this.subjectNavItems.add(navItem);
                            return;
                        case "user":
                            this.userNavItems.add(navItem);
                            return;
                    }
                }
            },
            drawSud: function(){
                new Backbone.Model().fetch({
                    url: Portal.staff().get('staff-user-disclaimer-content').get('href'),
                    success: function(response) {
                        var view = new sudView({model: response}),
                            modal = new ModalDialogView(),
                            header = new AppletHeaderView();
                        Portal.execute("open-modal-dialog", {
                            header: header,
                            content: view,
                            closeBtn: false,
                            scrollable: true
                        });
                    }
                });
            },
            getAppletOptions: function (appletId) {
                return _.find( Portal.packageData().get('applets'), function(applet) { return applet.id === appletId; }).options;
            },
            setPatientContext: function (options) {
                if (typeof options.url !== "undefined") {
                    // GET patient for current session
                    Portal.patient().fetch({
                        url: options.url
                    }).success( function () {
                        Portal.vent.trigger("load:patient");

                        // POST patient to patient-context service
                        Portal.patient().save({}, {
                            url: Portal.staff().get('user-context').get('href'),
                            dataType: "json"
                        });
                    });
                
                } else if (typeof options.patient !== "undefined") {
                    // set patient for current session
                    parser.preFlattenLinks( options.patient.attributes );
                    Portal.patient().clear();
                    Portal.patient().set( options.patient.attributes );

                    Portal.vent.trigger("load:patient");

                    // POST patient to patient-context service
                    Portal.patient().save({}, {
                        url: Portal.staff().get('user-context').get('href'),
                        dataType: "json"
                    });
                }

            }
        });
    });


